PSO52EX ;BHAM ISC/AGV - API FOR ORIGINAL, REFILL, AND PARTIAL DATA ;07/13/06 10:30 am
 ;;7.0;OUTPATIENT PHARMACY;**252,267**;DEC 1997;Build 3
 ;
 ;REFERENCE TO ^DPT SUPPORTED BY DBIA 10035
 ;REFERENCE TO ^PSDRUG SUPPORTED BY DBIA 221
 ;
EXTRACT(SDATE,EDATE,LIST) ;MAIN DRIVER
 ;SDATE: START DATE OF RECORD RETRIEVAL [REQUIRED]
 ;EDATE: END DATE OF RECORD RETRIEVAL [OPTIONAL]
 ;LIST: SUBSCRIPT NAME USED IN ^TMP GLOBAL [REQUIRED]
 ;
 Q:$G(LIST)=""
 K ^TMP($J,LIST)
 I '$G(SDATE) S ^TMP($J,LIST,0)="-1^NO DATA FOUND" Q
 I '$G(EDATE) S EDATE=DT
 D SEND
 Q
 ;       
SEND ;SENDS CONTROL TO $$CROSS.  RECEIVES AND TRACKS COUNTS.
 N ALCOUNT S ALCOUNT=$$CROSS("AL")
 N AMCOUNT S AMCOUNT=$$CROSS("AM")
 N TCOUNT S TCOUNT=ALCOUNT+AMCOUNT
 IF TCOUNT>0 S ^TMP($J,LIST,0)=TCOUNT
 ELSE  S ^TMP($J,LIST,0)="-1^NO DATA FOUND"
 Q
 ;
CROSS(REF) ;SETS UP ^TMP GLOBAL.  SENDS FOR ORIGINAL, REFILL AND/OR PARTIAL FILL DATA
 N PSOIEN,PSOFILL,PSOCOUNT,DATE,END
 S DATE=SDATE-.001,END=(EDATE+1),PSOIEN="",PSOFILL="",PSOCOUNT=0
 F  S DATE=$O(^PSRX(REF,DATE)) Q:'DATE!(END'>DATE)  D
 .F  S PSOIEN=$O(^PSRX(REF,DATE,PSOIEN)) Q:'PSOIEN  D
 ..F  S PSOFILL=$O(^PSRX(REF,DATE,PSOIEN,PSOFILL)) Q:PSOFILL=""  D
 ...S ^TMP($J,LIST,REF,DATE,PSOIEN,PSOFILL)=""
 ...I REF="AL",PSOFILL=0 S PSOCOUNT=PSOCOUNT+1 D ORIG(PSOIEN) Q
 ...I REF="AL",PSOFILL>0 S PSOCOUNT=PSOCOUNT+1 D REFILL(PSOIEN,PSOFILL) Q
 ...I REF="AM" S PSOCOUNT=PSOCOUNT+1 D PART(PSOIEN,PSOFILL) Q
 Q PSOCOUNT
 ;
REFILL(IEN,FILL) ;REFILL
 D:'$D(^TMP($J,LIST,IEN,.01)) ORIG(IEN)
 N PSORFL S PSORFL=$G(^PSRX(IEN,1,FILL,0))
 S ^TMP($J,LIST,IEN,"RF",FILL,.01)=$P(PSORFL,U,1)_"^"_$$FMTE^XLFDT($P(PSORFL,U,1),1)
 S ^TMP($J,LIST,IEN,"RF",FILL,1)=$P(PSORFL,U,4)
 S ^TMP($J,LIST,IEN,"RF",FILL,1.1)=$P(PSORFL,U,10)
 S ^TMP($J,LIST,IEN,"RF",FILL,1.2)=$P(PSORFL,U,11)
 S ^TMP($J,LIST,IEN,"RF",0)=$G(^TMP($J,LIST,IEN,"RF",0))+1
 Q
 ;
PART(IEN,FILL) ;PARTIAL FILL
 D:'$D(^TMP($J,LIST,IEN,.01)) ORIG(IEN)
 N PSOPART S PSOPART=$G(^PSRX(IEN,"P",FILL,0))
 S ^TMP($J,LIST,IEN,"P",FILL,.01)=$P(PSOPART,U,1)_"^"_$$FMTE^XLFDT($P(PSOPART,U,1),1)
 S ^TMP($J,LIST,IEN,"P",FILL,.04)=$P(PSOPART,U,4)
 S ^TMP($J,LIST,IEN,"P",FILL,.041)=$P(PSOPART,U,10)
 S ^TMP($J,LIST,IEN,"P",FILL,.042)=$P(PSOPART,U,11)
 S ^TMP($J,LIST,IEN,"P",0)=$G(^TMP($J,LIST,IEN,"P",0))+1
 Q
 ;
ORIG(IEN) ;ORIGINAL FILL
 N PSOORIG S PSOORIG=$G(^PSRX(IEN,0))
 S ^TMP($J,LIST,IEN,.01)=$P(PSOORIG,U,1)
 S ^TMP($J,LIST,IEN,2)=$S($P(PSOORIG,U,2)>0:$P(PSOORIG,U,2)_"^"_$P($G(^DPT($P($G(PSOORIG),U,2),0)),U,1),1:"")
 S ^TMP($J,LIST,IEN,6)=$S($P(PSOORIG,U,6)>0:$P(PSOORIG,U,6)_"^"_$P($G(^PSDRUG($P($G(PSOORIG),U,6),0)),U,1),1:"")
 S ^TMP($J,LIST,IEN,7)=$P(PSOORIG,U,7)
 S ^TMP($J,LIST,IEN,8)=$P(PSOORIG,U,8)
 S ^TMP($J,LIST,IEN,17)=$P(PSOORIG,U,17)
 Q
 ;
REF(SDATE,EDATE,LIST) ; "AD" XREF RETRIEVAL
 ;SDATE: START DATE OF "AD" XREF RETRIEVAL [REQUIRED]
 ;EDATE: END DATE OF "AD" XREF RETRIEVAL [OPTIONAL]
 ;LIST: SUBSCRIPT NAME USED IN ^TMP GLOBAL [REQUIRED]
 ;
 Q:$G(LIST)=""
 K ^TMP($J,LIST)
 I '$G(SDATE) S ^TMP($J,LIST,0)="-1^NO DATA FOUND" Q
 I '$G(EDATE) S EDATE=SDATE
 N PSORXN,PSOFILL
 S DATE=SDATE-.001,END=EDATE+1,PSORXN="",PSOFILL=""
 F  S DATE=$O(^PSRX("AD",DATE)) Q:'DATE!(END'>DATE)  D
 .F  S PSORXN=$O(^PSRX("AD",DATE,PSORXN)) Q:'PSORXN  D
 ..F  S PSOFILL=$O(^PSRX("AD",DATE,PSORXN,PSOFILL)) Q:PSOFILL=""  D
 ...S ^TMP($J,LIST,"AD",DATE,PSORXN,PSOFILL)=""
 Q
 ;
ARXREF(PSODATE,PSOIEN,PSOFILL) ; SUSPENSE STATUS CHECK
 ;PSODATE: RELEASED DATE/TIME
 ;PSOIEN: INTERNAL ENTRY NUMBER
 ;PSOFILL: FILL NUMBER OF PRESCRIPTION
 ;
 I $G(PSODATE)=""!($G(PSOIEN)="")!($G(PSOFILL)="") Q 0
 N RESULT S RESULT=0
 I $D(^PSRX("AR",PSODATE,PSOIEN,PSOFILL)) S RESULT=1
 Q RESULT
